/*
 * Echo klientas
 * 
 * Author: Kstutis Mizara
 * Description: Isiunia serveriui praneim ir j gauna
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <winsock2.h>

#define BUFFLEN 1024


int main(int argc, char *argv[]){
    WSADATA wsaData;
    if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0)
    {
       return -1;                        
    }
    unsigned int port;
    int s_socket;
    struct sockaddr_in servaddr; // Serverio adreso struktra

    char buffer[BUFFLEN];

    if (argc != 3){
        fprintf(stderr,"USAGE: %s <ip> <port>\n",argv[0]);
        exit(1);
    }

    port = atoi(argv[2]);

    if ((port < 1) && (port > 65535)){
        printf("ERROR #1: invalid port specified.\n");
        exit(1);
    }

    /*
     * Sukuriamas socket'as
     */
    if ((s_socket = socket(AF_INET, SOCK_STREAM,0))< 0){
        fprintf(stderr,"ERROR #2: cannot create socket.\n");
        exit(1);
    }
                                
   /*
    * Ivaloma ir upildoma serverio struktra
    */

    memset(&servaddr,0,sizeof(servaddr));
    servaddr.sin_family = AF_INET; // nurodomas protokolas (IP)
    servaddr.sin_port = htons(port); // nurodomas portas
    
    /*
     * Iveriamas simboli eilutje uraytas ip  skaitin form ir
     * nustatomas serverio adreso struktroje.
     */
     servaddr.sin_addr.s_addr = inet_addr(argv[1]);
 /*   if ( inet_aton(argv[1], &servaddr.sin_addr) <= 0 ) {
        fprintf(stderr,"ERROR #3: Invalid remote IP address.\n");
        exit(1);
    }
*/
    /* 
     * Prisijungiama prie serverio
     */
    if (connect(s_socket,(struct sockaddr*)&servaddr,sizeof(servaddr))<0){
        fprintf(stderr,"ERROR #4: error in connect().\n");
        exit(1);
    }
    for (;;){
    printf("Enter the message: ");
    fgets(buffer, BUFFLEN, stdin);
    if (strcmp(buffer, "quit\n") == 0)
    {
       close(s_socket);
       return 0;
    }                   
    /*
     * Isiuniamas praneimas serveriui
     */
    send(s_socket,buffer,strlen(buffer),0);

    memset(&buffer,0,BUFFLEN);
    /*
     * Praneimas gaunamas i serverio
     */
    recv(s_socket,buffer,BUFFLEN,0);
    printf("Server sent: %s\n", buffer);
    }
    /*
     * Socket'as udaromas
     */
    close(s_socket);
    return 0;
}
